// Создание объектов для работы с WMI и реестром
var activeXObject = new ActiveXObject("WbemScripting.SWbemLocator");
var activeXObjectConnectServer = activeXObject.ConnectServer(null, "root\\default");
var workObject = activeXObjectConnectServer.Get("StdRegProv");
var shellObject = new ActiveXObject("WScript.Shell");

// Константы для корневых ключей реестра
HKCU = 0x80000001;
HKLM = 0x80000002;

// Флаги и переменные для ошибок
var flagErrorWhenConfiguringBrowser = false;
var textErrorWhenConfiguringBrowser = "";
var resultOperation = "";
var resultSecondTypeOperation = false;

// Глобальное сообщение об ошибке
var mainMessageError = "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435\u0021\u0021\u0021 \u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f " +
    "\u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430\u003a\r\n";
// "Внимание!!! Во время проведения проверки произошла ошибка:"

// Функция вывода сообщения и завершения
function setMessage(messageError, message) {
    textErrorWhenConfiguringBrowser += messageError;
    shellObject.Popup(mainMessageError + textErrorWhenConfiguringBrowser);
    WScript.Quit(0);
}

// === Проверка прав доступа к настройке окружения ===
try {
    resultOperation = workObject.CheckAccess(HKCU, "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings", 6, true);
    if (resultOperation == 2 || resultOperation == 5) {
        setMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435\u0021\u0021\u0021 \u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 " +
            "\u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u044f\u003a \u0412\u0430\u0448\u0438\u0445 \u043f\u0440\u0430\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 " +
            "\u0434\u043b\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0431\u043e\u0437\u0440\u0435\u0432\u0430\u0442\u0435\u043b\u044f " +
            "\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0434\u043b\u044f \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f " +
            "\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u044f\u0021\r\n");
    }
}
catch (e) {
    setMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435\u0021\u0021\u0021 \u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 " +
        "\u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u044f\u003a \u0412\u0430\u0448\u0438\u0445 \u043f\u0440\u0430\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 " +
        "\u0434\u043b\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0431\u043e\u0437\u0440\u0435\u0432\u0430\u0442\u0435\u043b\u044f " +
        "\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0434\u043b\u044f \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f " +
        "\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u044f\u0021\r\n");
}

// === Проверка прав на настройку Internet Explorer ===
try {
    resultOperation = workObject.CheckAccess(HKCU, "Software\\Microsoft\\Internet Explorer\\Main", 2, true);
    if (resultOperation == 2 || resultOperation == 5) {
        setMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435\u0021\u0021\u0021 \u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 " +
            "\u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u044f\u003a \u0412\u0430\u0448\u0438\u0445 \u043f\u0440\u0430\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 " +
            "\u0434\u043b\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0431\u043e\u0437\u0440\u0435\u0432\u0430\u0442\u0435\u043b\u044f " +
            "\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0434\u043b\u044f \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f " +
            "\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u044f\u0021\r\n");
    }
}
catch (e) {
    setMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435\u0021\u0021\u0021 \u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 " +
        "\u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u044f\u003a \u0412\u0430\u0448\u0438\u0445 \u043f\u0440\u0430\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 " +
        "\u0434\u043b\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u0431\u043e\u0437\u0440\u0435\u0432\u0430\u0442\u0435\u043b\u044f " +
        "\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0434\u043b\u044f \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f " +
        "\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043e\u043a\u0440\u0443\u0436\u0435\u043d\u0438\u044f\u0021\r\n");
}

// === Настройка параметров IE ===
try {
    shellObject.RegWrite("HKCU\\Software\\Microsoft\\Internet Explorer\\Main\\Friendly http errors", "no");
} catch (e) {
    textErrorWhenConfiguringBrowser += "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 Friendly http errors \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.\r\n";
    flagErrorWhenConfiguringBrowser = true;
}

try {
    shellObject.RegWrite("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\WarnonBadCertRecving", 0, "REG_DWORD");
} catch (e) {
    textErrorWhenConfiguringBrowser += "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 WarnonBadCertRecving \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.\r\n";
    flagErrorWhenConfiguringBrowser = true;
}

// Включение TLS 1.2
try {
    var sp = shellObject.RegRead("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\SecureProtocols");
    var newSp = (+sp) | 2048; // TLS 1.2
    if (newSp !== sp) {
        shellObject.RegWrite("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\SecureProtocols", newSp, "REG_DWORD");
    }
} catch (e) {
    textErrorWhenConfiguringBrowser += "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 SecureProtocols \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.\r\n";
    flagErrorWhenConfiguringBrowser = true;
}

// === Добавление доверенных сайтов в зону безопасного доступа ===
try {
    var canWriteEscDomains = workObject.CheckAccess(HKCU, "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ZoneMap\\EscDomains", 1, true) !== 2;
    var canWriteDomains = workObject.CheckAccess(HKCU, "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ZoneMap\\Domains", 1, true) !== 2;

    if (!canWriteEscDomains && !canWriteDomains) {
        textErrorWhenConfiguringBrowser += "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u044b\u0445 \u0443\u0437\u043b\u043e\u0432.\r\n";
        flagErrorWhenConfiguringBrowser = true;
    } else {
        // Список доменов для добавления как *.domain.com
        var domains = [
            "belstat.gov.by",
            "portal2.ssf.gov.by",
            "oauth.uas.nces.by",
            "portal.nalog.gov.by",
            "nalog.gov.by",
            "usd.nces.by",
            "vat.gov.by"
        ];

        // Список URL с HTTPS
        var urls = [
            "iplk.portal.nalog.gov.by",
            "lkfl.portal.nalog.gov.by",
            "www.portal.nalog.gov.by"
        ];

        // Добавляем домены
        for (var i = 0; i < domains.length; i++) {
            try {
                if (canWriteEscDomains) {
                    shellObject.RegWrite("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ZoneMap\\EscDomains\\" + domains[i] + "\\*", 2, "REG_DWORD");
                }
                if (canWriteDomains) {
                    shellObject.RegWrite("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ZoneMap\\Domains\\" + domains[i] + "\\*", 2, "REG_DWORD");
                }
            } catch (e) {
                textErrorWhenConfiguringBrowser += "Не удалось добавить домен: " + domains[i] + "\r\n";
                flagErrorWhenConfiguringBrowser = true;
            }
        }

        // Добавляем URL с протоколом HTTPS
        for (var j = 0; j < urls.length; j++) {
            try {
                if (canWriteEscDomains) {
                    shellObject.RegWrite("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ZoneMap\\EscDomains\\" + urls[j] + "\\https", 2, "REG_DWORD");
                }
                if (canWriteDomains) {
                    shellObject.RegWrite("HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\ZoneMap\\Domains\\" + urls[j] + "\\https", 2, "REG_DWORD");
                }
            } catch (e) {
                textErrorWhenConfiguringBrowser += "Не удалось добавить URL: " + urls[j] + "\r\n";
                flagErrorWhenConfiguringBrowser = true;
            }
        }
    }
} catch (e) {
    textErrorWhenConfiguringBrowser += "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u0434\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u044b\u0445 \u0443\u0437\u043b\u043e\u0432.\r\n";
    flagErrorWhenConfiguringBrowser = true;
}

// === Настройка зоны безопасности (Internet Settings\Zones\2) ===
var zoneKeys = [
    { key: "160A", value: 0 },
    { key: "2500", value: 3 },
    { key: "1201", value: 0 },
    { key: "1400", value: 0 },
    { key: "1406", value: 0 },
    { key: "1200", value: 0 },
    { key: "2000", value: 0 },
    { key: "1803", value: 0 }
];

for (var k = 0; k < zoneKeys.length; k++) {
    var regKey = "HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\2\\" + zoneKeys[k].key;
    try {
        resultOperation = shellObject.RegRead(regKey);
        if (resultOperation != zoneKeys[k].value) {
            shellObject.RegWrite(regKey, zoneKeys[k].value, "REG_DWORD");
        }
    } catch (e) {
        try {
            shellObject.RegWrite(regKey, zoneKeys[k].value, "REG_DWORD");
        } catch (ex) {
            textErrorWhenConfiguringBrowser += "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 " + zoneKeys[k].key + " \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c.\r\n";
            flagErrorWhenConfiguringBrowser = true;
        }
    }
}

// === Итоговое сообщение ===
if (flagErrorWhenConfiguringBrowser) {
    shellObject.Popup("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435\u0021\u0021\u0021 \u0412\u043e \u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 " +
        "\u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0438 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 " +
        "\u043e\u0448\u0438\u0431\u043a\u0438\u003a\r\n" + textErrorWhenConfiguringBrowser);
} else {
    shellObject.Popup("\u041D\u0430\u0441\u0442\u0440\u043E\u0439\u043A\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043D\u0430 \u0443\u0441\u043F\u0435\u0448\u043D\u043E!\r\n" +
        "\u041F\u0435\u0440\u0435\u0437\u0430\u043F\u0443\u0441\u0442\u0438\u0442\u0435 Internet Explorer.");
}