/* eslint-env browser, es6 */

function listingClicked(event) {
  event.preventDefault();

  const markers = this.getElementsByClassName('pacifisthtml-list-marker');
  const firstRow = this.closest('tr');

  if (markers.length !== 0 && markers[0].classList.contains('pacifisthtml-list-marker-open')) {
    for (const marker of markers) {
      marker.classList.remove('pacifisthtml-list-marker-open');
    }
    
    changeVisibility(firstRow, false);
  } else {
    for (const marker of markers) {
      marker.classList.add('pacifisthtml-list-marker-open');
    }

    changeVisibility(firstRow, true);
  }
}

function rowsToUpdate(row) {
  const marker = row.getElementsByClassName('pacifisthtml-list-marker')[0];

  if (!marker) { return []; }
  let rows = [];

  const level = parseInt(row.getAttribute('level'));

  if (marker.classList.contains('pacifisthtml-list-marker-open')) {
    for (let next = row.nextElementSibling; next; next = next.nextElementSibling) {
      const nextLevel = parseInt(next.getAttribute('level'));

      if (nextLevel === level + 1) {
        rows.push(next);
        rowsToUpdate(next).forEach(e => rows.push(e));
      } else if (nextLevel <= level) {
        break;
      }
    }
  } else {
    for (let next = row.nextElementSibling;
      next && (parseInt(next.getAttribute('level')) > level);
      next = next.nextElementSibling) {
      if (next.classList.contains('pacifisthtml-show') && !next.classList.contains('pacifisthtml-fading')) {
        next.classList.add('pacifisthtml-fading');
        rows.push(next);
      }
    }
  }

  return rows;
}

function changeVisibility(firstRow, show) {
  const rows = rowsToUpdate(firstRow);

  if (rows.length === 0) { return; }

  const parent = firstRow.parentElement;

  for (const each of parent.getElementsByClassName('placeholder')) {
    parent.removeChild(each);
  }

  const height = firstRow.offsetHeight * rows.length;
  const placeholder = document.createElement('tr');

  const firstToChange = firstRow.nextElementSibling;

  if (show) {
    placeholder.setAttribute('style', `height:${height}px;display:block`);
    placeholder.setAttribute('class', 'placeholder pacifisthtml-shrink pacifisthtml-show');
    parent.insertBefore(placeholder, firstToChange);

    setTimeout(() => {
      placeholder.classList.remove('pacifisthtml-shrink');
      placeholder.addEventListener('transitionend', () => {
        parent.removeChild(placeholder);

        for (const each of rows) {
          each.classList.add('pacifisthtml-show');
          setTimeout(() => each.classList.remove('pacifisthtml-fading'), 20);
        }
      }, { once: true });
    }, 20);
  } else {
    firstToChange.addEventListener('transitionend', () => {
      placeholder.setAttribute('style', `height:${height}px;display:block`);
      placeholder.setAttribute('class', 'placeholder pacifisthtml-show');

      for (let row of rows) {
        row.classList.remove('pacifisthtml-show');
      }

      parent.insertBefore(placeholder, firstToChange);

      setTimeout(() => {
        placeholder.classList.add('pacifisthtml-shrink');
        placeholder.addEventListener('transitionend', () => parent.removeChild(placeholder), { once: true });
      }, 20);
    }, { once: true });
  }
}

for (const element of document.getElementsByClassName('pacifisthtml-click-area')) {
  element.onclick = listingClicked;
}
