const scripts = document.getElementsByTagName('script');
const path = scripts[scripts.length - 1].src.split('?')[0];  // remove any ?query
const mydir = path.split('/').slice(0, -1).join('/') + '/';  // remove last filename part of path

function insertGraphics(lores, hires, width, height, tag_class, alt) {
    document.write(
        `<img class="${tag_class}" srcset="${hires} 2x" src="${lores}" height="${height}" width="${width}" alt="${alt}" />`
    );
}

function insertAppIcon(size, tag_class) {
    insertGraphics(
       `${mydir}../gfx/Pacifist_${size}.png`,
       `${mydir}../gfx/Pacifist_${size * 2}.png`,
       size,
       size,
       tag_class,
       'Pacifist Icon'
    );
}

function insertHeaderAppIcon() {
	insertAppIcon(64, 'header_icon');
}
